*
*
* CONFIGURE AN IP ADDRESS
*
* IN FUTURE THIS WILL HANDLE DHCP, STATIC, AND LINK-LOCAL
* CONFIGURATION. FOR NOW, IT JUST MAKES A LINK-LOCAL ADDRESS,
* TRYING TO FOLLOW RFC 3927.
*
* SEE ALTERNATE ENTRY POINT BELOW FOR DHCP.
* SEE ALSO RECONFIG SUBROUTINE.
*
*
IPADDR DS 4 ; OUR CLIENT IP ADDRESS
*
* SUBNET MASK
*
NETMASK HEX FFFF0000
NETMASKA HEX 00000000 ; AND'D VERSION OF NETMASK
*
*
* SUBNET BROADCAST ADDRESS
*
NETBCAST HEX 00000000
*
*
*
IPCONFIG
 LDA #0
 STA IPCONFMODE ; ALWAYS LINK-LOCAL FOR NOW
* CLEAR ROUTER ADDR; NOT USED FOR LINK-LOCAL
 LDX #3
:RCL STA ROUTER,X
 DEX
 BPL :RCL
*
* IF POSSIBLE, USE THE SAME LINK LOCAL ADDRESS
* ACROSS REBOOTS.
*
 LDA IPADDR
 CMP #169
 BNE :SELADDR ; NO, MAKE AN ADDRESS
 LDA IPADDR+1
 CMP #254
 BEQ IPCONFIG2
*
*
* GENERATE AN ADDRESS USING THE KEYIN RANDOM SEED
*
* NOTE: UNDER PRODOS, RNDL AND RNDH ARE ALWAYS INITIALIZED
* TO A CONSTANT VALUE.
*
:SELADDR LDA #169 ; FIRST TWO OCTETS ARE FIXED
 STA IPADDR
 LDA #254
 STA IPADDR+1
* THIRD OCTET CANNOT BE 0 OR 255
 LDA RNDL
 EOR KBDSTRB
 BNE :CHECK2
 CLC  ; ADD 1 TO GET 169.254.1.X
 ADC #1
 BNE :STORE ; ALWAYS TAKEN
:CHECK2 CMP #255
 BNE :STORE
 SEC ; SUBTRACT 1 TO GET 169.254.254.X
 SBC #1
:STORE STA IPADDR+2
 LDA RNDH
 ADC #1 ; DON'T CARE WHETHER CARRY IS SET OR NOT
 EOR $FBBF ; MACHINE ID BYTE
:STORE2 STA IPADDR+3
*
*
* ALTERNATE ENTRY POINT, USED FOR DHCP
*
IPCONFIG2
*
* NOW, AS A RESPONSIBLE NETWORK CITIZEN, WE NEED TO SEND AN
* ARP PROBE TO SEE IF ANYONE ELSE IS USING THIS ADDRESS.
* WE RELY ON THE INCOMING ARP HANDLER TO NOTIFY US OF
* A CONFLICT. IF NO ONE SQUAWKS, THEN WE'RE GOOD TO GO.
* JUST SET THE PROBENUM COUNTER AND LET MAINLOOP DO THE REST.
*
 LDA #3 ; NUMBER OF PROBE PACKETS TO SEND
 STA PROBENUM
 LDA #2 ; WE CAN SET ANNOUNCE NUM HERE TOO
 STA ANNNUM
*
* COPY THE IP ADDRESS TO THE ARP REQUEST TEMPLATE
* AND CLEAR THE ARP TABLE
*
 JSR ARPINIT
* CREATE THE AND'D VERSION OF NETMASK
 LDX #3
:NML LDA IPADDR,X
 AND NETMASK,X
 STA NETMASKA,X
 DEX
 BPL :NML
*
* SETUP THE DIRECTED BROADCAST ADDRESS
* FIRST INVERT THE NETMASK, THEN ORA WITH NETMASKA TO
* GET, E.G. 169.254.255.255 OR 192.168.2.255
* DUE TO SECURITY RESTRICTIONS FOR ROUTERS IN RFC 2644,
* IT IS UNLIKELY THAT DIRECT BROADCASTS WILL BE FORWARDED
*
 LDX #3
 LDY #3
:BCL LDA NETMASK,X
 EOR #255
 STA NETBCAST,Y
 DEY
 DEX
 BPL :BCL
 LDX #3
 LDY #3
:BCL2 LDA NETMASKA,X
 ORA NETBCAST,Y
 STA NETBCAST,Y
 DEY
 DEX
 BPL :BCL2
*
* ADJUST TTL IF NEEDED
*
 LDA IPCONFMODE
 AND #%10000010 ; TEST FOR DHCP CONFIGURATION
 BEQ :DONE ; LINK-LOCAL ADDRESS
 LDX #22 ; OFFSET FOR TTL IN IP HEAD
 LDA #64 ; ADJUST TTL TO 64
 STA OUTPHEAD,X
:DONE RTS
*
*
* RECONFIGURE IP ADDRESS
* THIS IS CALLED FROM ARP ACD ROUTINES.
*
IPRECONFIG
 LDA IPCONFMODE ; CHECK MODE
 AND #%01111111
 BNE :DHCP ; RECONFIGURE DHCP
 JMP IPCONFIG ; RECONFIGURE LINK-LOCAL
:DHCP
 JSR DHCPSENDDEC ; DECLINE IP ADDRESS
 LDA #0 ; STATUS = NO ADDRESS
 STA IPCONFMODE ; SET THIS STATUS
 RTS
